<?php

/**
 * Sets the body-tag class attribute.
 *
 * Adds 'sidebar-left', 'sidebar-right' or 'sidebars' classes as needed.
 */
function phptemplate_body_class($left, $right) {
  if ($left != '' && $right != '') {
    $class = 'sidebars';
  }
  else {
    if ($left != '') {
      $class = 'sidebar-left';
    }
    if ($right != '') {
      $class = 'sidebar-right';
    }
  }

  if (isset($class)) {
    print ' class="'. $class .'"';
  }
}

/**
 * Return a themed breadcrumb trail.
 *
 * @param $breadcrumb
 *   An array containing the breadcrumb links.
 * @return a string containing the breadcrumb output.
 */
function phptemplate_breadcrumb($breadcrumb) {
  if (!empty($breadcrumb)) {
    return '<div class="breadcrumb">'. implode(' › ', $breadcrumb) .'</div>';
  }
}

/**
 * Override or insert PHPTemplate variables into the templates.
 */
function phptemplate_preprocess_page(&$vars) {
  $vars['tabs2'] = menu_secondary_local_tasks();

  // Hook into color.module
  if (module_exists('color')) {
    _color_page_alter($vars);
  }
}

/**
 * Add a "Comments" heading above comments except on forum pages.
 */
function garland_preprocess_comment_wrapper(&$vars) {
  if ($vars['content'] && $vars['node']->type != 'forum') {
    $vars['content'] = '<h2 class="comments">'. t('Comments') .'</h2>'.  $vars['content'];
  }
}

/**
 * Returns the rendered local tasks. The default implementation renders
 * them as tabs. Overridden to split the secondary tasks.
 *
 * @ingroup themeable
 */
function phptemplate_menu_local_tasks() {
  return menu_primary_local_tasks();
}

/**
 * Returns the themed submitted-by string for the comment.
 */
function phptemplate_comment_submitted($comment) {
  return t('!datetime — !username',
    array(
      '!username' => theme('username', $comment),
      '!datetime' => format_date($comment->timestamp)
    ));
}

/**
 * Returns the themed submitted-by string for the node.
 */
function phptemplate_node_submitted($node) {
  return t('!datetime — !username',
    array(
      '!username' => theme('username', $node),
      '!datetime' => format_date($node->created),
    ));
}

/**
 * Generates IE CSS links for LTR and RTL languages.
 */
function phptemplate_get_ie_styles() {
  global $language;

  $iecss = '<link type="text/css" rel="stylesheet" media="all" href="'. base_path() . path_to_theme() .'/fix-ie.css" />';
  if ($language->direction == LANGUAGE_RTL) {
    $iecss .= '<style type="text/css" media="all">@import "'. base_path() . path_to_theme() .'/fix-ie-rtl.css";</style>';
  }

  return $iecss;
}
      
         
/*
function phptemplate_uc_product_price($price, $class, $no_label = 0) {

   //drupal_set_message("Selwyn here", "status");
   print_r($price);
   exit();


 if ($no_label) {
     if ($price=="0.000")
       $output .= t("Call for price");
     else
       $output .= uc_currency_format($price);
 }
 else {
   switch ($class) {
     case 'list-price':
       $output .= t('List Price: !price', array('!price' => uc_currency_format($price)));
     break;
     case 'cost':
       $output .= t('Cost: !price', array('!price' => uc_currency_format($price)));
     break;
     case 'sell-price':
     if ($price=="0.000")
       $output .= t('Call for price');
     else
       $output .= t('Price: !price', array('!price' => uc_currency_format($price)));

     break;
     default:
       $output .= uc_currency_format($price);
     break;
   }
 }

 return $output;
}
*/  


function DPS_preprocess_node(&$vars){



  if($vars['node']->type == 'product') {

    $content = '<div id="productholder">';
    
    // Setup our image div.
    $content .= '<div id="prodimageholder">';
      $content .= $vars['node']->content['image']['#value'];
      $content .= '<p class="smalltext">[+] Click image to enlarge</p>';
    $content .= '</div>'; 
    
    $content .= '<div id="rightproductside">';
      $content .= $vars['node']->content['body']['#value'];
      
      if ($vars['node']->field_call_for_pricing[0]['value'] == 'Yes'){
      	$content .='<p class="bigtext">' . t('Call 419-738-0167 for pricing') . '</p>';
        $content .= '<h2>' . $vars['node']->content['model']['#value'] . '</h2>';
      }
      else {
        if ($vars['node']->list_price > 0 && !$vars['printing']) {
          $content .= '<del>' . $vars['node']->content['list_price']['#value'] . '</del>';
        }
        
        $content .= '<p class="bigtext">' . $vars['node']->content['sell_price']['#value'] . '</p>';
        
        $content .= '<h2>' . $vars['node']->content['model']['#value'] . '</h2>';
        
        $content .= $vars['node']->content['add_to_cart']['#value'];
      }
      
    $content .= '</div>';
    
    $content .= '<div class="clear"></div>';
    
    $content .= '</div>';
     
    $vars['content'] = $content;
  }
//  else if($vars['node']->type == 'product' && !$vars['teaser']) {
//    $vars['content'] = '<h1>TEST!@!' . $node->title . '</h1><hr>';
//    $vars['content'] .= $vars['node']->content['image']['#value'];
//    $vars['content'] .= $vars['node']->content['sell_price']['#value'];
//    $vars['content'] .= $vars['node']->content['add_to_cart']['#value'];
//    $vars['content'] .= '<br class="clear" />';
//  } 
  

}
