/**
 * @file
 * Adds effects and behaviors to elements on the checkout page.
 */

// Make this compatible with other libraries other than jQuery
(function($) {

Drupal.behaviors.ucdzCopyAddress = function(context) {
  var targetCheckbox = $("input[name*=copy_address]", context);

  if (targetCheckbox.length > 0) {
    var target = targetCheckbox.attr('id').substr(11, 7) == 'billing' ? 'billing' : 'delivery';
    var source = target == 'billing' ? 'delivery' : 'billing';
    var countryChangedAjax = false;
    var zoneNeedsUpdate = false;

    // Subscribe to global ajax events so can can correctly
    // copy address data
    $(document).ajaxStart(function() {
      countryChangedAjax = true;
    });

    $(document).ajaxStop(function() {
      countryChangedAjax = false;

      if (zoneNeedsUpdate) {
        var $source = $('#edit-panes-' + source + '-' + source + '-zone');
        var $target = $('#edit-panes-' + target + '-' + target + '-zone');
        zoneNeedsUpdate = false;

        if (!uc_disable_zones_zone_validate($source, $target)) {
          targetCheckbox.removeAttr('checked');
          $('#' + target + '-pane div.address-pane-table').slideDown();
          alert(Drupal.t('Sorry, we do not allow @section to @zone', {'@section' : target, '@zone' : $source.find('option:selected').html()}));
        }
        else {
          $target.val($source.val());
        }
      }
    });

    // Hide target pane when targetCheckbox checked
    targetCheckbox.change(function() {
      if (targetCheckbox.is(':checked')) {
        // Copy textbox data from source to target
        $('#' + source + '-pane input').trigger('change');

        // Copy country from source to target
        if ($('#edit-panes-' + target + '-' + target + '-country').length > 0) {
          $('#edit-panes-' + target + '-' + target + '-country')
          .val($('#edit-panes-' + source + '-' + source + '-country').val())
          .trigger('change');
        }

        // Copy zone from source to target
        var $source = $('#edit-panes-' + source + '-' + source + '-zone');
        var $target = $('#edit-panes-' + target + '-' + target + '-zone');

        // When the country is changed it sets off an AJAX call to get
        // all the zones for that country. We can't copy zone data until
        // any AJAX updates are done
        if (!countryChangedAjax) {
          if (!uc_disable_zones_zone_validate($source, $target)) {
            targetCheckbox.removeAttr('checked');
            $('#' + target + '-pane div.address-pane-table').slideDown();
            alert(Drupal.t('Sorry, we do not allow @section to @zone', {'@section' : target, '@zone' : $source.find('option:selected').html()}));
          }
          else {
            $target.val($source.val());
          }
        }
        else {
          zoneNeedsUpdate = true;
        }

        // Hide all target fields
        $('#' + target + '-pane div.address-pane-table').slideUp();
      }
      else {
        // Show all target fields
        $('#' + target + '-pane div.address-pane-table').slideDown();
      }
    });

    // Copy textbox data from source to target whenever source changes
    $('#' + source + '-pane input:text', context).not('.ucdzCopyAddress-processed').addClass('ucdzCopyAddress-processed').change(function() {
      if (targetCheckbox.is(':checked')) {
        var $source = $(this);
        var $target = $('#' + sourceToTargetId($source.attr('id'), target));

        $target.val($source.val());
      }
    });

    // Copy select box data from source to target whenever source changes
    $('#' + source + '-pane select', context).not('.ucdzCopyAddress-processed').addClass('ucdzCopyAddress-processed').bind('change.ucdzCopyAddress', function() {
      if (targetCheckbox.is(':checked')) {
        var $source = $(this);
        var $target = $('#' + sourceToTargetId($source.attr('id'), target));

        // If country select box changed
        if ($source.attr('id') == 'edit-panes-' + source + '-' + source + '-country') {
          $target.val($source.val()).trigger('change');
        }

        // If zone select box changed
        if ($source.attr('id') == 'edit-panes-' + source + '-' + source + '-zone') {
          if (!uc_disable_zones_zone_validate($source, $target)) {
            targetCheckbox.removeAttr('checked');
            $('#' + target + '-pane div.address-pane-table').slideDown();
            alert(Drupal.t('Sorry, we do not allow @section to @zone', {'@section' : target, '@zone' : $source.find('option:selected').html()}));
          }
          else {
            $target.val($source.val());
          }
        }
      }
    });
  }
}

// Return true if selected source zone exists in target zones
function uc_disable_zones_zone_validate(sourceZone, targetZone) {
  if (targetZone.find('option[value=' + sourceZone.val() + ']').length == 0) {
    return false;
  }

  return true;
}

// Helper function to convert field names from source to target
function sourceToTargetId(id, target) {
  var reg = new RegExp(/^edit-panes-\w+-\w+-([\w\d-]+)$/i);
  return id.replace(reg, 'edit-panes-' + target + '-' + target + '-$1');
}

})(jQuery)
